package org.jresearch.commons.gwt.client.widget;

import java.util.List;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.event.DynamicListUpdateEvent;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.common.collect.ImmutableList;

/**
 * Read only list that can be updated (from a side)
 *
 * @author kot
 */
public class DynamicList<T> {

	@Nonnull
	private ImmutableList<T> list = ImmutableList.of();
	@Nonnull
	private final Bus bus;

	public DynamicList(@Nonnull final Bus bus) {
		this.bus = bus;
	}

	public void update(@Nonnull final Iterable<T> newValues) {
		list = ImmutableList.copyOf(newValues);
		bus.fire(new DynamicListUpdateEvent(), this);
	}

	@Nonnull
	public List<T> getValues() {
		return list;
	}

	public int indexOf(final T value) {
		return list.indexOf(value);
	}

	public T get(final int index) {
		return list.get(index);
	}

	public boolean isEmpty() {
		return list.isEmpty();
	}

}
