package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import com.google.gwt.user.client.Command;

/**
 * The methods to show short notifications, confirmation etc to an user
 *
 * @author Kot
 */
public interface INotificator {

	public enum NotificationType {
		fatal, error, warning, info, debug, trace
	}

	/**
	 * Show Ok notification
	 *
	 * @param content
	 *            - notification to show
	 */
	void showNotification(@Nonnull String content);

	/**
	 * Show notification with given type
	 *
	 * @param type
	 *            - type of notification
	 * @param content
	 *            - notification to show
	 */
	void showNotification(@Nonnull NotificationType type, @Nonnull String content);

	/**
	 * Show error notification
	 *
	 * @param content
	 *            - notification to show
	 */
	void showError(@Nonnull String content);

	/**
	 * Shows confirmation to user, the command will be executed on positive
	 * confirmation
	 *
	 * @param content
	 *            - confirmation to show
	 * @param confirmCommand
	 *            - {@link Command} to execute
	 */
	void showConfirnation(@Nonnull String content, @Nonnull Command confirmCommand);

}
