package org.jresearch.commons.gwt.client.mvc.event;

import com.google.gwt.user.client.Command;
import com.google.web.bindery.event.shared.Event;

public class ErrorEvent extends Event<ErrorHandler> {

	public static final Type<ErrorHandler> TYPE = new Type<>();

	private final Throwable ex;
	private final Command command;

	public ErrorEvent(final String errorMessage) {
		this(new Exception(errorMessage, null));
	}

	public ErrorEvent(final Throwable ex, final Command command) {
		this.ex = ex;
		this.command = command;
	}

	public ErrorEvent(final Throwable ex) {
		this(ex, null);
	}

	@Override
	public Type<ErrorHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final ErrorHandler handler) {
		handler.onError(this);
	}

	public Throwable getException() {
		return ex;
	}

	public Command getCommand() {
		return command;
	}
}
