package org.jresearch.commons.gwt.client.app;

import java.util.List;
import java.util.logging.Logger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.client.base.resource.BaseRs;
import org.jresearch.commons.gwt.client.mvc.AbstractView;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ScrollEvent;

import com.google.gwt.dom.client.Document;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Window;

@SuppressWarnings("rawtypes")
public abstract class AbstractAppView<C extends AbstractAppController> extends AbstractView<C> {

    private static final Logger LOGGER = Logger.getLogger("org.jresearch.commons.gwt.app.client.mvc.AbstractAppView"); //$NON-NLS-1$

    @Nonnull
    protected final Bus bus;

    public AbstractAppView(@Nonnull final C controller, @Nonnull final Bus bus) {
        super(controller);
        this.bus = bus;
        Window.addWindowScrollHandler(new Window.ScrollHandler() {
            private int lastPosition;

            @SuppressWarnings({ "synthetic-access" })
            @Override
            public void onWindowScroll(final com.google.gwt.user.client.Window.ScrollEvent event) {
                final int scrollTop = event.getScrollTop();
                if (lastPosition != scrollTop) {
                    lastPosition = scrollTop;
                    final int scrollH = Document.get()
                            .getScrollHeight();
                    final int screenH = Document.get()
                            .getClientHeight();
                    if (scrollH - scrollTop <= screenH) {
                        LOGGER.fine(BaseRs.FMT.logScroll(scrollTop));
                        bus.fire(new ScrollEvent(scrollTop));
                    }
                }
            }
        });
    }

    public void onChangeOfflineMode(final boolean isOffline) {
        showInfo(BaseRs.TXT.offlineMode(isOffline));
    }

    public abstract void showAbout();

    public abstract boolean switchToModule(@Nonnull final String moduleId);

    /** show module in navigation, called from offline manager */
    public abstract boolean showModule(@Nonnull final String moduleId);

    /** hide module from navigation, called from offline manager */
    public abstract boolean hideModule(@Nonnull final String moduleId);

    public abstract void initModules(final List<IAppModule> modules);

    protected abstract void updateAppTitle(@Nullable SafeHtml viewTitle);

}
