package org.jresearch.commons.gwt.client.app;

import java.io.Serializable;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.base.resource.BaseRs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class GeneralModule implements IAppModule, Serializable {

	private static final long serialVersionUID = 899032954650462280L;

	@Nonnull
	private final String name;
	@Nonnull
	private final String moduleId;
	@Nonnull
	private String moduleDescription = ""; //$NON-NLS-1$
	@Nonnull
	private String icon = ""; //$NON-NLS-1$

	public GeneralModule(@Nonnull final String moduleId) {
		this(moduleId, moduleId);
	}

	public GeneralModule(@Nonnull final String name, @Nonnull final String moduleId) {
		this.name = name;
		this.moduleId = moduleId;
	}

	@Nonnull
	@Override
	public String getModuleId() {
		return moduleId;
	}

	@Nonnull
	@Override
	public String getName() {
		return name;
	}

	/**
	 * @return the moduleDescription
	 */
	@Override
	public String getModuleDescription() {
		return moduleDescription.isEmpty() ? BaseRs.TXT.noDescription() : moduleDescription;
	}

	/**
	 * @param moduleDescription
	 *            the moduleDescription to set
	 */
	public void setModuleDescription(@Nonnull final String moduleDescription) {
		this.moduleDescription = moduleDescription;
	}

	/**
	 * @return the icon
	 */
	@Override
	public String getIcon() {
		return icon;
	}

	/**
	 * @param icon
	 *            the icon to set
	 */
	public void setIcon(@Nonnull final String icon) {
		this.icon = icon;
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
				.add("name", name) //$NON-NLS-1$
				.add("moduleId", moduleId) //$NON-NLS-1$
				.add("moduleDescription", moduleDescription) //$NON-NLS-1$
				.add("icon", icon) //$NON-NLS-1$
				.toString();
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(getModuleId());
	}

	@Override
	public boolean equals(final Object object) {
		if (object instanceof GeneralModule) {
			final GeneralModule that = (GeneralModule) object;
			return Objects.equal(this.getModuleId(), that.getModuleId());
		}
		return false;
	}

}
