package org.jresearch.commons.gwt.client.model;

import java.io.Serializable;

import javax.annotation.Nonnull;

import com.google.common.base.MoreObjects;
import com.google.common.base.MoreObjects.ToStringHelper;

public class DomainNewModel<O> implements IDomainNewModel<O>, IMappedObject, Serializable {

	private static final long serialVersionUID = -570554224857825838L;

	private String name;
	private O id;
	private String mappedFrom;

	public DomainNewModel() {
		// default
	}

	public DomainNewModel(final DomainNewModel<O> model) {
		name = model.getName();
		id = model.getId();
		mappedFrom = model.getMappedFrom();
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public O getId() {
		return id;
	}

	public void setId(final O id) {
		this.id = id;
	}

	@Override
	public String getMappedFrom() {
		return mappedFrom;
	}

	@Override
	public void setMappedFrom(final String mappedFrom) {
		this.mappedFrom = mappedFrom;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (id == null) {
			return super.hashCode();
		}
		final int prime = 31;
		int result = 1;
		result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final DomainNewModel<?> other = (DomainNewModel<?>) obj;
		if (getId() == null) {
			if (other.getId() != null) {
				return false;
			}
			return super.equals(obj);
		} else if (!getId().equals(other.getId())) {
			return false;
		}
		return true;
	}

	@Nonnull
	protected <S extends DomainNewModel<O>> ToStringHelper toStringHelper(@Nonnull final S object) {
		//@formatter:off
        return MoreObjects
                .toStringHelper(object)
                .add("id", id) //$NON-NLS-1$
                .add("name", name) //$NON-NLS-1$
                .omitNullValues();
        //@formatter:on
	}

	@Override
	public String toString() {
		return toStringHelper(this).toString();
	}

}
