package org.jresearch.commons.gwt.client.model.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.tools.Dates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class GwtLocalDateModel implements Serializable {

    private static final long serialVersionUID = -2019419200502189876L;

    /** from 1 to 31 */
    private int day;
    /** from 1 to 12 */
    private int month;
    private int year;

    public GwtLocalDateModel() {
        // GWT
    }

    public GwtLocalDateModel(final int day, final int month, final int year) {
        this.day = day;
        this.month = month;
        this.year = year;
    }

    public GwtLocalDateModel(final Date value) {
        this(Dates.createCalendar(value));
    }

    public GwtLocalDateModel(final Calendar value) {
        this(value.get(Calendar.DAY_OF_MONTH), value.get(Calendar.MONTH) + 1, value.get(Calendar.YEAR));
    }

    public GwtLocalDateModel(final GwtLocalDateModel date) {
        this(date.getDay(), date.getMonth(), date.getYear());
    }

    /**
     * @return the day
     */
    public int getDay() {
        return day;
    }

    /**
     * @return the month
     */
    public int getMonth() {
        return month;
    }

    /**
     * @return the year
     */
    public int getYear() {
        return year;
    }

    @SuppressWarnings("deprecation")
    @Nonnull
    public Date getDate() {
        return new Date(year - 1900, month - 1, day);
    }

    /**
     * @param day
     *            the day to set
     */
    public void setDay(final int day) {
        this.day = day;
    }

    /**
     * @param month
     *            the month to set
     */
    public void setMonth(final int month) {
        this.month = month;
    }

    /**
     * @param year
     *            the year to set
     */
    public void setYear(final int year) {
        this.year = year;
    }

    public void setDate(final Date date) {
        final Calendar value = Dates.createCalendar(date);
        setYear(value.get(Calendar.YEAR));
        setMonth(value.get(Calendar.MONTH) + 1);
        setDay(value.get(Calendar.DAY_OF_MONTH));
    }

    @SuppressWarnings("boxing")
    @Override
    public int hashCode() {
        return Objects.hashCode(getDay(), getMonth(), getYear());
    }

    @SuppressWarnings("boxing")
    @Override
    public boolean equals(final Object object) {
        if (object instanceof GwtLocalDateModel) {
            final GwtLocalDateModel that = (GwtLocalDateModel) object;
            return Objects.equal(this.getDay(), that.getDay())
                    && Objects.equal(this.getMonth(), that.getMonth())
                    && Objects.equal(this.getYear(), that.getYear());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("day", day) //$NON-NLS-1$
                .add("month", month) //$NON-NLS-1$
                .add("year", year) //$NON-NLS-1$
                .toString();
    }

}
