package org.jresearch.commons.gwt.client.model.time;

import static com.google.common.base.Objects.*;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.tools.Dates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class GwtLocalDateTimeModel implements Serializable {

    private static final long serialVersionUID = 5840767318129944964L;

    @Nonnull
    private GwtLocalDateModel date;
    @Nonnull
    private GwtLocalTimeModel time;

    public GwtLocalDateTimeModel() {
        this(Dates.createCalendar());
    }

    public GwtLocalDateTimeModel(final Calendar date) {
        this(new GwtLocalDateModel(date), new GwtLocalTimeModel(date));
    }

    public GwtLocalDateTimeModel(final Date date) {
        this(date, date);
    }

    public GwtLocalDateTimeModel(final Date date, final Date time) {
        this(new GwtLocalDateModel(date), new GwtLocalTimeModel(time));
    }

    public GwtLocalDateTimeModel(@Nonnull final GwtLocalDateModel date, @Nonnull final GwtLocalTimeModel time) {
        this.date = date;
        this.time = time;
    }

    /**
     * @return the date
     */
    @Nonnull
    public GwtLocalDateModel getDate() {
        return date;
    }

    /**
     * @return the time
     */
    @Nonnull
    public GwtLocalTimeModel getTime() {
        return time;
    }

    /**
     * @param date
     *            the date to set
     */
    public void setDate(@Nonnull final GwtLocalDateModel date) {
        this.date = date;
    }

    /**
     * @param time
     *            the time to set
     */
    public void setTime(@Nonnull final GwtLocalTimeModel time) {
        this.time = time;
    }

    public Date toDate() {
        return new Date(getDate().getDate().getTime() + getTime().getMiliseconds());
    }

    @Override
    public String toString() {
        //@formatter:off
        return MoreObjects.toStringHelper(this)
                .add("date", date) //$NON-NLS-1$
                .add("time", time) //$NON-NLS-1$
                .toString();
        //@formatter:on
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(date, time);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        final GwtLocalDateTimeModel other = (GwtLocalDateTimeModel) obj;
        return equal(date, other.date) && equal(time, other.time);
    }

}
