package org.jresearch.commons.gwt.client.model.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import org.jresearch.commons.gwt.shared.tools.Dates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class GwtLocalTimeModel implements Serializable {

    private static final long serialVersionUID = -4731534946440240947L;

    /** from 00:00 */
    private long miliseconds;

    public GwtLocalTimeModel() {
        // GWT
    }

    public GwtLocalTimeModel(final long miliseconds) {
        this.miliseconds = miliseconds;
    }

    public GwtLocalTimeModel(final int hours, final int minutes) {
        this(hours, minutes, 0);
    }

    public GwtLocalTimeModel(final int hours, final int minutes, final int seconds) {
        this(hours, minutes, seconds, 0);
    }

    public GwtLocalTimeModel(final int hours, final int minutes, final int seconds, final int miliseconds) {
        this(((hours * 60 + minutes) * 60 + seconds) * 1000 + miliseconds);
    }

    public GwtLocalTimeModel(final Date date) {
        this(Dates.getDayTime(date));
    }

    public GwtLocalTimeModel(final Calendar date) {
        this(Dates.getDayTime(date));
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#hashCode()
     */
    @SuppressWarnings("boxing")
    @Override
    public int hashCode() {
        return Objects.hashCode(miliseconds);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final GwtLocalTimeModel other = (GwtLocalTimeModel) obj;
        if (miliseconds != other.miliseconds) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        //@formatter:off
        return MoreObjects.toStringHelper(this)
                .add("miliseconds", miliseconds) //$NON-NLS-1$
                .toString();
        //@formatter:on
    }

    public Date getDate() {
        return Dates.setDayTime(miliseconds);
    }

    /**
     * @return the miliseconds
     */
    public long getMiliseconds() {
        return miliseconds;
    }

    /**
     * @param miliseconds
     *            the miliseconds to set
     */
    public void setMiliseconds(final long miliseconds) {
        this.miliseconds = miliseconds;
    }

    public void setDate(final Date date) {
        setMiliseconds(Dates.getDayTime(date));
    }

}
