package org.jresearch.commons.gwt.client.mvc.event;

import org.jresearch.commons.gwt.shared.tools.Strings;

import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;

public class ErrorEvent extends GwtEvent<ErrorHandler> {

	@SuppressWarnings("unused")
	public static Type<ErrorHandler> TYPE = new Type<ErrorHandler>();

	private final Throwable ex;
	private final Command command;

	public ErrorEvent(final String errorMessage) {
		this(new Exception(errorMessage, null));
	}

	public ErrorEvent(final String errorTemplate, final Object... parameters) {
		this(new Exception(Strings.format(errorTemplate, parameters)), null);
	}

	public ErrorEvent(final Throwable ex, final Command command) {
		this.ex = ex;
		this.command = command;
	}

	public ErrorEvent(final Throwable ex) {
		this(ex, null);
	}

	@Override
	public Type<ErrorHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final ErrorHandler handler) {
		handler.onError(this);
	}

	public Throwable getException() {
		return ex;
	}

	public Command getCommand() {
		return command;
	}
}
