package org.jresearch.commons.gwt.client.validation;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.INotificator;
import org.jresearch.commons.gwt.shared.tools.Strings;

import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.ui.TextBox;

public class Validation {

	public static boolean pattern(final String value, final RegExp expression, final boolean allowEmpty) {
		return pattern(value, expression, null, null, allowEmpty);
	}

	public static boolean pattern(@Nonnull final TextBox box, final RegExp expression, final boolean allowEmpty) {
		return pattern(box.getValue(), expression, null, null, allowEmpty);
	}

	public static boolean pattern(@Nonnull final TextBox box, final RegExp expression, final String notifyMessage, @Nonnull final INotificator notificator, final boolean allowEmpty) {
		return pattern(box.getValue(), expression, notifyMessage, notificator, allowEmpty);
	}

	public static boolean pattern(final String value, final RegExp expression, final String notifyMessage, final INotificator notificator, final boolean allowEmpty) {
		if ((!allowEmpty || Strings.isValuable(value)) && !expression.test(value)) {
			notify(notifyMessage, notificator);
			return false;
		}
		return true;
	}

	public static boolean checkNull(final String value) {
		return notNull(value, null, null);
	}

	public static boolean checkNull(@Nonnull final TextBox box) {
		return notNull(box.getValue(), null, null);
	}

	public static boolean checkNull(@Nonnull final TextBox box, final String notifyMessage, @Nonnull final INotificator notificator) {
		return notNull(box.getValue(), notifyMessage, notificator);
	}

	public static boolean notNull(final String value, final String notifyMessage, final INotificator notificator) {
		if (Strings.isEmpty(value)) {
			notify(notifyMessage, notificator);
			return false;
		}
		return true;
	}

	public static boolean atLeastOne(final String notifyMessage, @Nonnull final INotificator notificator, final String... values) {
		if (Strings.isValuableAny(values)) {
			return true;
		}
		notify(notifyMessage, notificator);
		return false;
	}

	public static void notify(final String notifyMessage, final INotificator notificator) {
		if (notificator != null && notifyMessage != null) {
			notificator.showNotification(notifyMessage);
		}
	}

}