package org.jresearch.commons.gwt.shared.loader;

import java.io.Serializable;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;

public class LoadConfigBean implements LoadConfig, Serializable {

	private static final long serialVersionUID = -8647396475310263560L;

	private Map<String, Object> loadProperties = Maps.newHashMap();

	@Override
	public <O> void setValue(@Nonnull final String property, final O value) {
		loadProperties.put(property, value);
	}

	@Override
	public void unsetValue(@Nonnull final String property) {
		loadProperties.remove(property);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <O> O getValue(@Nonnull final String property) {
		return (O) loadProperties.get(property);
	}

	/**
	 * To prevent final
	 */
	@SuppressWarnings("unused")
	private void setLoadProperties(final Map<String, Object> loadProperties) {
		this.loadProperties = loadProperties;
	}

}
