package org.jresearch.commons.gwt.shared.tools;

import static java.lang.Math.*;

public class Colors {

	private Colors() {
		super();
	}

	public static Rgb html2rgb(final String color) {
		return new Rgb(Integer.parseInt(color.substring(1, 3), 16), Integer.parseInt(color.substring(3, 5), 16), Integer.parseInt(color.substring(5, 7), 16));
	}

	public static String rgb2html(final Rgb color) {
		return new StringBuilder('#').append(toHexString(color.getR())).append(toHexString(color.getR())).append(toHexString(color.getR())).toString();
	}

	private static String toHexString(final int v) {
		final StringBuilder sb = new StringBuilder(Integer.toHexString(v).toUpperCase());
		if (sb.length() < 2) {
			sb.insert(0, '0'); // pad with leading zero if needed
		}
		return sb.toString();
	}

	public static Lab rgb2Lab(final Rgb color) {
		final double rf = f1(color.getR());
		final double gf = f1(color.getG());
		final double bf = f1(color.getB());

		final double X = (0.4124f * rf + 0.3576f * gf + 0.1805f * bf) / 95.0429;
		final double Y = (0.2126f * rf + 0.7152f * gf + 0.0722f * bf) / 100.0;
		final double Z = (0.0193f * rf + 0.1192f * gf + 0.9505f * bf) / 108.89;

		final double fX = f2(X);
		final double fY = f2(Y);
		final double fZ = f2(Z);

		return new Lab((116f * fY) - 16f, 500f * (fX - fY), 200f * (fY - fZ));
	}

	private static double f1(final double v) {
		return ((v > 0.04045) ? (Math.exp(Math.log((v + 0.055) / 1.055) * 2.4)) : v / 12.92) * 100;
	}

	private static double f2(final double v) {
		return v > 0.008856f ? Math.exp(Math.log(v) / 3) : 7.787 * v + 16 / 116;
	}

	public static double distance(final Rgb color1, final Rgb color2) {
		return distance(rgb2Lab(color1), rgb2Lab(color2));
	}

	public static double distance(final Lab lab1, final Lab lab2) {
		return sqrt(pow(lab1.getL() - lab2.getL(), 2) + pow(lab1.getA() - lab2.getA(), 2) + pow(lab1.getB() - lab2.getB(), 2));
	}

}
