package org.jresearch.commons.gwt.shared.tools;

import java.io.Serializable;

import com.google.common.base.MoreObjects;

public class Rgb implements Serializable {

	private static final long serialVersionUID = -1325812547663862226L;

	private int r;
	private int g;
	private int b;

	public Rgb() {
		// GWT
	}

	public Rgb(final int r, final int g, final int b) {
		this.r = r;
		this.g = g;
		this.b = b;
	}

	/**
	 * @return the r
	 */
	public int getR() {
		return r;
	}

	/**
	 * @param r
	 *            the r to set
	 */
	public void setR(final int r) {
		this.r = r;
	}

	/**
	 * @return the g
	 */
	public int getG() {
		return g;
	}

	/**
	 * @param g
	 *            the g to set
	 */
	public void setG(final int g) {
		this.g = g;
	}

	/**
	 * @return the b
	 */
	public int getB() {
		return b;
	}

	/**
	 * @param b
	 *            the b to set
	 */
	public void setB(final int b) {
		this.b = b;
	}

	@Override
	public String toString() {
		//@formatter:off
        return MoreObjects.toStringHelper(this)
                .add("r", r) //$NON-NLS-1$
                .add("g", g) //$NON-NLS-1$
                .add("b", b) //$NON-NLS-1$
                .toString();
        //@formatter:on
	}

}
