package org.jresearch.commons.gwt.shared.tools;

import com.google.common.base.Objects;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;

public class Strings {

	public static SafeHtml getSafeHtml(final String unsafeString, final String defaultValue) {
		final SafeHtmlBuilder builder = new SafeHtmlBuilder();
		return (Strings.isEmpty(unsafeString) ? builder.appendHtmlConstant(defaultValue) : builder.appendEscaped(unsafeString)).toSafeHtml();
	}

	public static boolean isValuableAny(final String... values) {
		for (final String value : values) {
			if (isValuable(value)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isEmpty(final String value) {
		return com.google.common.base.Strings.nullToEmpty(value).trim().isEmpty();
	}

	public static boolean isValuable(final String value) {
		return !isEmpty(value);
	}

	public static String format(final String format, final Object... args) {
		if (null == args || 0 == args.length) {
			return format;
		}
		if (GWT.isClient()) {
			final JsArrayString array = newArray();
			for (final Object arg : args) {
				array.push(String.valueOf(arg)); // TODO: smarter conversion?
			}
			return nativeFormat(format, array);
		}
		return format;
		// return MessageFormat.format(format, args);
	}

	private static native JsArrayString newArray()/*-{
		return [];
	}-*/;

	private static native String nativeFormat(final String format, final JsArrayString args)/*-{
		return format.replace(/{(\d+)}/g, function(match, number) {
			return typeof args[number] != 'undefined' ? args[number] : match;
		});
	}-*/;

	public static boolean equalTrimm(final String str1, final String str2) {
		return Objects.equal(com.google.common.base.Strings.nullToEmpty(str1).trim(), com.google.common.base.Strings.nullToEmpty(str2).trim());
	}

}