package org.jresearch.commons.gwt.client.app;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.AbstractModule;
import org.jresearch.commons.gwt.client.entry.DirectUrlHandler;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.InitEvent;

import com.google.gwt.user.client.History;
import com.google.inject.Inject;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class BaseAppModule extends AbstractModule {

    private final DirectUrlHandler directUrlHandler;

    @Inject
    public BaseAppModule(@Nonnull final DirectUrlHandler directUrlHandler, @Nonnull final Bus bus) {
        super(bus);
        this.directUrlHandler = directUrlHandler;
    }

    @Override
    protected void startUp() {
        super.startUp();
        bus.fire(new InitEvent());
        History.addValueChangeHandler(directUrlHandler);
        History.fireCurrentHistoryState();
    }

}
