package org.jresearch.commons.gwt.client.event;

import com.google.web.bindery.event.shared.Event;

public class ChangeOfflineModeEvent extends Event<ChangeOfflineModeHandler> {

	public static Type<ChangeOfflineModeHandler> TYPE = new Type<>();

	private final boolean offlineMode;

	public ChangeOfflineModeEvent(boolean offlineMode) {
		this.offlineMode = offlineMode;
	}

	@Override
	public Type<ChangeOfflineModeHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final ChangeOfflineModeHandler handler) {
		handler.onChangeOfflineMode(this);
	}

	public boolean isOfflineMode() {
		return offlineMode;
	}

}
