package org.jresearch.commons.gwt.client.app;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.client.mvc.event.module.ModuleEvent;

import com.google.gwt.resources.client.ImageResource;

public interface IAppModule {

	/**
	 * @return name to show
	 */
	@Nonnull
	String getName();

	/**
	 * @return id to create {@link ModuleEvent} to fire on name selection
	 */
	@Nonnull
	String getModuleId();

	/**
	 * @return id of module's group
	 */
	@Nonnull
	String getGroup();

	@Nonnull
	String getModuleDescription();

	@Nullable
	ImageResource getIcon();

	boolean supportsOffline();

}
