package org.jresearch.commons.gwt.client.model.localization;

import java.io.Serializable;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class LocaleModel implements Serializable {

    private static final long serialVersionUID = -570554207821588L;

    @Nonnull
    public static final LocaleModel DEFAULT = new LocaleModel();
    public static final char SEP = '_';
    /**
     * Name of language that use as default. By setting that language user will
     * create record with default (root) locate
     */
    public static final String DEFAULT_LANG = "en"; //$NON-NLS-1$

    private String language;
    private String country;
    private String variant;
    private String displayVariant;
    private String displayCountry;
    private String displayLanguage;

    /** Name of root (default) locale */
    public static final String DEFAULT_NAME = "default"; //$NON-NLS-1$

    public String getLanguage() {
        return language == null ? "" : language; //$NON-NLS-1$
    }

    public String getCountry() {
        return country == null ? "" : country; //$NON-NLS-1$
    }

    public String getVariant() {
        return variant == null ? "" : variant; //$NON-NLS-1$
    }

    public String getDisplayVariant() {
        return displayVariant == null ? getVariant() : displayVariant;
    }

    public String getDisplayCountry() {
        return displayCountry == null ? getCountry() : displayCountry;
    }

    public String getDisplayLanguage() {
        return displayLanguage == null ? getLanguage() : displayLanguage;
    }

    /**
     * @param language
     *            the language to set
     */
    public void setLanguage(final String language) {
        this.language = language;
    }

    /**
     * @param country
     *            the country to set
     */
    public void setCountry(final String country) {
        this.country = country;
    }

    /**
     * @param variant
     *            the variant to set
     */
    public void setVariant(final String variant) {
        this.variant = variant;
    }

    /**
     * @param displayVariant
     *            the displayVariant to set
     */
    public void setDisplayVariant(final String displayVariant) {
        this.displayVariant = displayVariant;
    }

    /**
     * @param displayCountry
     *            the displayCountry to set
     */
    public void setDisplayCountry(final String displayCountry) {
        this.displayCountry = displayCountry;
    }

    /**
     * @param displayLanguage
     *            the displayLanguage to set
     */
    public void setDisplayLanguage(final String displayLanguage) {
        this.displayLanguage = displayLanguage;
    }

    /**
     * Copy-paste from toString method of {@link java.util.Locale} class due to
     * GWT limitations
     */
    @JsonIgnore
    public String getLocaleName() {
        final boolean l = getLanguage().length() != 0;
        final boolean c = getCountry().length() != 0;
        final boolean v = getVariant().length() != 0;
        final StringBuilder result = new StringBuilder(getLanguage());
        if (c || (l && v)) {
            result.append('_').append(getCountry()); // This may just append '_'
        }
        if (v && (l || c)) {
            result.append('_').append(getVariant());
        }
        return result.length() == 0 ? DEFAULT_NAME : result.toString();
    }

    public LocaleModel up() {
        if (isEmpty(getLanguage()) && isEmpty(getCountry()) && isEmpty(getVariant())) {
            return null;
        }
        final LocaleModel result = new LocaleModel();
        if (isNotEmpty(getVariant())) {
            result.setLanguage(getLanguage());
            result.setCountry(getCountry());
            result.setVariant(up(getVariant()));
        } else if (isNotEmpty(getCountry())) {
            result.setLanguage(getLanguage());
        }
        return result;
    }

    private static String up(final String localeName) {
        int index = localeName.lastIndexOf('_');
        if (index <= 0) {
            return ""; //$NON-NLS-1$
        }
        while (index > 0 && localeName.charAt(index - 1) == '_') {
            index--;
        }
        return localeName.substring(0, index);
    }

    @Override
    public String toString() {
        return new StringBuilder("Locale: ").append(getLocaleName()).toString(); //$NON-NLS-1$
    }

    private static boolean isEmpty(final String string) {
        return string == null || string.length() == 0;
    }

    private static boolean isNotEmpty(final String string) {
        return !isEmpty(string);
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getLocaleName().hashCode();
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocaleModel)) {
            return false;
        }
        final LocaleModel other = (LocaleModel) obj;
        return other.getLocaleName().equals(getLocaleName());
    }

}
