package org.jresearch.commons.gwt.client.model.time;

import java.util.Calendar;
import java.util.Date;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.tools.Dates;

/**
 * Wrapper for {@link Date} to correct convert it to joda LocalTime
 *
 * @author kot
 *
 */
public class LocalTimeModel extends DateModel {

    private static final long serialVersionUID = -7212458218351299483L;

    public LocalTimeModel() {
        // for GWT
    }

    public LocalTimeModel(@Nonnull final Date date) {
        super(date);
    }

    public LocalTimeModel(final int hour, final int minutes) {
        super(new Date((hour * 60 + minutes) * 60 * 1000));
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getDate() == null) ? 0 : Dates.createTimeCalendar(getDate(), Calendar.MILLISECOND).hashCode());
        return result;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DateModel other = (DateModel) obj;
        if (getDate() == null) {
            if (other.getDate() != null) {
                return false;
            }
        } else if (!Dates.isSameTime(getDate(), other.getDate(), Calendar.MILLISECOND)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return getDate() != null ? Dates.printTime(getDate()) : super.toString();
    }

}
