package org.jresearch.commons.gwt.client.widget;

import java.util.List;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.event.DynamicListUpdateEvent;
import org.jresearch.commons.gwt.client.event.DynamicListUpdateHandler;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

public abstract class DynamicListBinding<T> implements DynamicListUpdateHandler {

	private final DynamicList<T> list;

	public DynamicListBinding(final DynamicList<T> list, final Bus bus) {
		this.list = list;
		bus.addHandlerToSource(DynamicListUpdateEvent.TYPE, list, this);
	}

	@Override
	public void onDynamicListUpdate(final DynamicListUpdateEvent event) {
		update(getValues());
	}

	@Nonnull
	public List<T> getValues() {
		return list.getValues();
	}

	abstract public void update(final List<T> values);

}
