package org.jresearch.commons.gwt.client.widget;

import static com.google.gwt.query.client.GQuery.*;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.AbstractController;
import org.jresearch.commons.gwt.client.mvc.AbstractView;
import org.jresearch.commons.gwt.client.mvc.ViewCommand;
import org.jresearch.commons.gwt.client.tool.DeferredTask;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.query.client.Properties;
import com.google.gwt.query.client.css.TakesCssValue;
import com.google.gwt.query.client.css.TakesCssValue.CssSetter;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public final class Uis {

	private static final String ATTR_DISABLED = "disabled"; //$NON-NLS-1$
	private static final String ATTR_HEIGHT = "height"; //$NON-NLS-1$
	@Nonnull
	public static final String TAG_BR = "<br>"; //$NON-NLS-1$
	public static final String TAG_OPEN = "<"; //$NON-NLS-1$
	public static final String TAG_CLOSE = ">"; //$NON-NLS-1$
	@Nonnull
	public static final String NOTHING = ""; //$NON-NLS-1$
	public static final SafeHtml NOTHING_SH = SafeHtmlUtils.fromSafeConstant(NOTHING);
	public static final String ACTIVE_STYLE = "is-active"; //$NON-NLS-1$
	public static final String INACTIVE_STYLE = "is-inactive"; //$NON-NLS-1$
	public static final String VISIBLE_STYLE = "is-visible"; //$NON-NLS-1$
	public static final String HIDDEN_STYLE = "is-hidden"; //$NON-NLS-1$
	public static final String SELECTED_STYLE = "is-selected"; //$NON-NLS-1$
	public static final int SHOW_DELAY = 50;
	public static final int HIDE_DELAY = 300;
	@Nonnull
	public static final String FORM_PH_ATTR = "placeholder"; //$NON-NLS-1$
	@Nonnull
	public static final String FORM_TYPE_ATTR = "type"; //$NON-NLS-1$
	@Nonnull
	public static final String FORM_TYPE_TXT = "text"; //$NON-NLS-1$
	@Nonnull
	public static final String FORM_TYPE_EML = "email"; //$NON-NLS-1$
	@Nonnull
	public static final String FORM_TYPE_PWD = "password"; //$NON-NLS-1$
	@Nonnull
	public static final String FORM_TYPE_SUBMIT = "submit"; //$NON-NLS-1$

	public static final String TAG_B_O = "<b>"; //$NON-NLS-1$
	public static final String TAG_B_C = "</b>"; //$NON-NLS-1$

	private Uis() {
		// prevent from creation
	}

	/**
	 * Set uiObject style
	 */
	@Nonnull
	public static <I extends UIObject, T> I setStyle(@Nonnull final I uiObject, @Nonnull final TakesCssValue<T> property, final T value) {
		final Element element = uiObject.getElement();
		if (element != null) {
			setStyle(element, property, value);
		}
		return uiObject;
	}

	/**
	 * Set uiObject style
	 */
	@Nonnull
	public static <I extends UIObject> I setStyle(@Nonnull final I uiObject, @Nonnull final CssSetter... setters) {
		final Element element = uiObject.getElement();
		if (element != null) {
			setStyle(element, setters);
		}
		return uiObject;
	}

	/**
	 * Set uiObject style
	 */
	@Nonnull
	public static <I extends UIObject> I setStyle(@Nonnull final I uiObject, @Nonnull final Properties properties) {
		final Element element = uiObject.getElement();
		if (element != null) {
			setStyle(element, properties);
		}
		return uiObject;
	}

	/**
	 * Set uiObject style
	 */
	@Nonnull
	public static <I extends UIObject> I setStyle(@Nonnull final I uiObject, @Nonnull final String property, @Nonnull final String value) {
		final Element element = uiObject.getElement();
		if (element != null) {
			setStyle(element, property, value);
		}
		return uiObject;
	}

	/**
	 * Set element style
	 */
	@Nonnull
	public static <I extends Element, T> I setStyle(@Nonnull final I element, @Nonnull final TakesCssValue<T> property, final T value) {
		return setStyle(element, property.with(value));
	}

	/**
	 * Set element style
	 */
	@Nonnull
	public static <I extends Element> I setStyle(@Nonnull final I element, @Nonnull final Properties properties) {
		$(element).css(properties);
		return element;
	}

	/**
	 * Set element style
	 */
	@Nonnull
	public static <I extends Element> I setStyle(@Nonnull final I element, @Nonnull final CssSetter... setters) {
		$(element).css(setters);
		return element;
	}

	/**
	 * Set element style
	 */
	@Nonnull
	public static <I extends Element> I setStyle(@Nonnull final I element, @Nonnull final String property, @Nonnull final String value) {
		$(element).css(property, value);
		return element;
	}

	/**
	 * Set input type
	 */
	@Nonnull
	public static <I extends UIObject> I setType(@Nonnull final I input, @Nonnull final String type) {
		return set(input, FORM_TYPE_ATTR, type);
	}

	/**
	 * Set input placeholder
	 */
	@Nonnull
	public static <I extends UIObject> I setPlaceholder(@Nonnull final I input, final @Nonnull String placeholder) {
		return set(input, FORM_PH_ATTR, placeholder);
	}

	/**
	 * Set UiObgect attribute value
	 */
	@Nonnull
	public static <I extends UIObject> I set(@Nonnull final I uiObject, @Nonnull final String attributeName, @Nonnull final String value) {
		final Element element = uiObject.getElement();
		if (element != null) {
			set(element, attributeName, value);
		}
		return uiObject;
	}

	/**
	 * Set {@link Element} attribute value
	 */
	@Nonnull
	public static <I extends Element> I set(@Nonnull final I element, @Nonnull final String attributeName, @Nonnull final String value) {
		element.setAttribute(attributeName, value);
		return element;
	}

	/**
	 * Get {@link Element} attribute value
	 */
	@Nonnull
	public static String get(@Nonnull final UIObject uiObject, @Nonnull final String attributeName) {
		final Element element = uiObject.getElement();
		return element == null ? Uis.NOTHING : get(element, attributeName);
	}

	/**
	 * Get {@link Element} attribute value
	 */
	@SuppressWarnings("null")
	@Nonnull
	public static String get(@Nonnull final Element element, @Nonnull final String attributeName) {
		return element.getAttribute(attributeName);
	}

	/**
	 *
	 * @param object
	 *            to switch @return <code>true</code> if object become active,
	 *            <code>false</code> otherwise
	 */
	public static boolean switchActiveStyle(final UIObject object) {
		final boolean result = hasStyle(object, ACTIVE_STYLE);
		if (result) {
			offActiveStyle(object);
		} else {
			onActiveStyle(object);
		}
		return !result;
	}

	public static boolean hasStyle(final UIObject object, final String style) {
		return object.getStyleName().contains(style);
	}

	/**
	 * @param object
	 *            to turn off the active stile
	 */
	public static void offActiveStyle(final UIObject object) {
		offStyle(object, ACTIVE_STYLE);
	}

	/**
	 * @param object
	 *            to turn off the active stile
	 */
	public static void offActiveStyleWithVisible(final UIObject object) {
		offStyle(object, ACTIVE_STYLE);
		queueOffStyle(object, VISIBLE_STYLE);
	}

	/**
	 * @param object
	 *            to turn on the active stile
	 */
	public static void onActiveStyle(final UIObject object) {
		onStyle(object, ACTIVE_STYLE);
	}

	/**
	 * @param object
	 *            to turn on the active stile
	 */
	public static void onActiveStyleWithvisible(final UIObject object) {
		onStyle(object, VISIBLE_STYLE);
		queueOnStyle(object, ACTIVE_STYLE);
	}

	public static void switchStyle(@Nonnull final UIObject object, final boolean set, final String style) {
		if (set) {
			object.addStyleName(style);
		} else {
			object.removeStyleName(style);
		}
	}

	public static void switchStyle(final Element element, final boolean set, final String style) {
		if (set) {
			onStyle(element, style);
		} else {
			offStyle(element, style);
		}
	}

	/**
	 *
	 * @param object
	 *            to switch @return <code>true</code> if object become active,
	 *            <code>false</code> otherwise
	 */
	public static boolean switchStyle(@Nonnull final UIObject object, final String style) {
		final boolean result = !hasStyle(object, style);
		switchStyle(object, result, style);
		return result;
	}

	/**
	 * @param object
	 *            to turn off the active stile
	 */
	public static void offStyle(final UIObject object, final String style) {
		object.removeStyleName(style);
	}

	/**
	 * @param object
	 *            to turn on the active stile
	 */
	public static void onStyle(final UIObject object, final String style) {
		object.addStyleName(style);
	}

	/**
	 * @param object
	 *            to queue turn on the stile
	 */
	public static void queueOnStyle(final UIObject object, final String style) {
		new DeferredTask() {
			@Override
			public void run() {
				onStyle(object, style);
			}
		}.defer(SHOW_DELAY);
	}

	/**
	 * @param object
	 *            to queue turn on the stile
	 */
	public static void queueOffStyle(final UIObject object, final String style) {
		new DeferredTask() {
			@Override
			public void run() {
				offStyle(object, style);
			}
		}.defer(HIDE_DELAY);
	}

	public static boolean hasStyle(final Element element, final String style) {
		return element.getClassName().contains(style);
	}

	public static boolean switchActiveStyle(final Element element) {
		final boolean result = hasStyle(element, ACTIVE_STYLE);
		if (result) {
			offActiveStyle(element);
		} else {
			onActiveStyle(element);
		}
		return !result;
	}

	public static void offActiveStyle(final Element element) {
		offStyle(element, ACTIVE_STYLE);
	}

	public static void offActiveStyleWithVisible(final Element element) {
		offStyle(element, ACTIVE_STYLE);
		queueOffStyle(element, VISIBLE_STYLE);
	}

	public static void onActiveStyle(final Element element) {
		onStyle(element, ACTIVE_STYLE);
	}

	public static void onActiveStyleWithVisible(final Element element) {
		onStyle(element, VISIBLE_STYLE);
		queueOnStyle(element, ACTIVE_STYLE);
	}

	/**
	 * @param element
	 *            to queue turn on the stile
	 */
	public static void queueOnStyle(final Element element, final String style) {
		new DeferredTask() {
			@Override
			public void run() {
				onStyle(element, style);
			}
		}.defer(SHOW_DELAY);
	}

	/**
	 * @param element
	 *            to queue turn on the stile
	 */
	public static void queueOffStyle(final Element element, final String style) {
		new DeferredTask() {
			@Override
			public void run() {
				offStyle(element, style);
			}
		}.defer(HIDE_DELAY);
	}

	/**
	 * @param element
	 *            to turn off the active stile
	 */
	public static void offStyle(final Element element, final String style) {
		element.removeClassName(style);
	}

	/**
	 * @param element
	 *            to turn on the active stile
	 */
	public static void onStyle(final Element element, final String style) {
		element.addClassName(style);
	}

	/**
	 * Return first found element inside the widget with given CSS selector
	 */
	public static Element findByCssSelector(@Nonnull final UIObject widget, @Nonnull final String selector) {
		final Element element = widget.getElement();
		return element == null ? null : findByCssSelector(element, selector);
	}

	/**
	 * Return first found element inside the element with given CSS selector
	 */
	public static Element findByCssSelector(@Nonnull final Element element, @Nonnull final String selector) {
		return $(selector, element).get(0);
	}

	/**
	 * Return first found element inside the whole document with given CSS
	 * selector
	 */
	public static Element findByCssSelector(@Nonnull final String selector) {
		return $(selector).get(0);
	}

	/**
	 * Return first found element inside element with given style
	 */
	public static Element findByStyle(@Nonnull final UIObject widget, @Nonnull final String style) {
		final Element element = widget.getElement();
		return element == null ? null : findByStyle(element, style);
	}

	/**
	 * Return first found element inside the whole DOM with given style
	 */
	public static Element findByStyle(@Nonnull final String style) {
		return findByCssSelector(styleSelector(style));
	}

	/**
	 * Return first found element inside element with given style
	 */
	public static Element findByStyle(@Nonnull final Element element, @Nonnull final String style) {
		return findByCssSelector(element, styleSelector(style));
	}

	/**
	 * Return style selector
	 */
	@Nonnull
	public static String styleSelector(@Nonnull final String style) {
		return "." + style; //$NON-NLS-1$
	}

	/**
	 * Return id selector
	 */
	@Nonnull
	public static String idSelector(@Nonnull final String id) {
		return "#" + id; //$NON-NLS-1$
	}

	public static <V extends AbstractView<C>, C extends AbstractController<V>> void switchViewStyle(final C controller, final boolean set, final String style) {
		controller.executeCommand(new ViewCommand<V>() {
			@Override
			public void execute(final V v) {
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					@Override
					public void execute() {
						Uis.switchStyle(v.getContent(), set, style);
					}
				});
			}
		});
	}

	public static void offStyle(final NodeList<Element> elements, final String style) {
		for (int i = 0; i < elements.getLength(); i++) {
			offStyle(elements.getItem(i), style);
		}
	}

	public static void switchSiblingStyle(final Element element, final String childSelector, final String style) {
		final NodeList<Element> nodeList = $(childSelector, element.getParentNode()).get();
		for (int i = 0; i < nodeList.getLength(); i++) {
			offStyle(nodeList.getItem(i), style);
		}
		onStyle(element, style);
	}

	public static void add(@Nonnull final HTMLPanel panel, @Nonnull final Widget widget, @Nonnull final String selector) {
		final Element element = findByCssSelector(panel, selector);
		if (element == null) {
			panel.add(widget);
		} else {
			panel.add(widget, element);
		}
	}

	public static void setStyleNames(@Nonnull final UIObject widget, @Nonnull final String... styles) {
		widget.setStyleName(styles[0]);
		for (int i = 1; i < styles.length; i++) {
			widget.addStyleName(styles[i]);
		}
	}

	public static void addStyleNames(@Nonnull final UIObject widget, @Nonnull final String... styles) {
		for (int i = 0; i < styles.length; i++) {
			widget.addStyleName(styles[i]);
		}
	}

	public static void removeStyleNames(@Nonnull final UIObject widget, @Nonnull final String... styles) {
		for (int i = 0; i < styles.length; i++) {
			widget.removeStyleName(styles[i]);
		}
	}

	public static boolean isParentOrSame(@Nonnull final UIObject widget, final EventTarget trg) {
		return isParentOrSame(widget.getElement(), trg);
	}

	public static boolean isParentOrSame(final Element parentOrSame, final EventTarget trg) {
		return Node.is(trg) ? parentOrSame.isOrHasChild(Node.as(trg)) : false;
	}

	public static void clear(@Nonnull final UIObject parent, @Nonnull final String elementStyleSelector) {
		final Node element = findByStyle(parent, elementStyleSelector);
		if (element != null) {
			element.removeAllChildren();
		}
	}

	public static void setHeight(@Nonnull final Element element, final int height) {
		if (height >= 0) {
			element.getStyle().setPropertyPx(ATTR_HEIGHT, height);
		}
	}

	public static void enable(final UIObject uiObject, final boolean enabled) {
		enable(uiObject.getElement(), enabled);
	}

	public static void enable(final Element element, final boolean enabled) {
		element.setPropertyBoolean(ATTR_DISABLED, !enabled);
	}

}
