package org.jresearch.commons.gwt.client.tool;

import java.util.Collection;

public interface IListConverter<V, C extends Collection<V>> {

	/**
	 * Add new value to current model values
	 * 
	 * @param value
	 *            - new value
	 * @param modelValue
	 *            - current model values
	 * @return - update value to set
	 */
	C add(V value, C modelValue);

	/**
	 * Remove new value from current model values
	 * 
	 * @param value
	 *            - new value
	 * @param modelValue
	 *            - current model values
	 * @return - update value to set
	 */
	C remove(V value, C modelValue);

}
