package org.jresearch.commons.gwt.client.model.about;

import java.io.Serializable;

public class AboutModel implements Serializable {

	private static final long serialVersionUID = -570554307821588L;

	private String moduleName;
	private String moduleVersion;
	private String buildNum;
	private String buildDate;
	private String buildServer;

	/**
	 * @return the buildServer
	 */
	public String getBuildServer() {
		return buildServer;
	}

	/**
	 * @param buildServer
	 *            the buildServer to set
	 */
	public void setBuildServer(final String buildServer) {
		this.buildServer = buildServer;
	}

	/**
	 * @return the moduleName
	 */
	public String getModuleName() {
		return moduleName;
	}

	/**
	 * @param moduleName
	 *            the moduleName to set
	 */
	public void setModuleName(final String moduleName) {
		this.moduleName = moduleName;
	}

	/**
	 * @return the moduleVersion
	 */
	public String getModuleVersion() {
		return moduleVersion;
	}

	/**
	 * @param moduleVersion
	 *            the moduleVersion to set
	 */
	public void setModuleVersion(final String moduleVersion) {
		this.moduleVersion = moduleVersion;
	}

	/**
	 * @return the buildNum
	 */
	public String getBuildNum() {
		return buildNum;
	}

	/**
	 * @param buildNum
	 *            the buildNum to set
	 */
	public void setBuildNum(final String buildNum) {
		this.buildNum = buildNum;
	}

	/**
	 * @return the buildDate
	 */
	public String getBuildDate() {
		return buildDate;
	}

	/**
	 * @param buildDate
	 *            the buildDate to set
	 */
	public void setBuildDate(final String buildDate) {
		this.buildDate = buildDate;
	}

	/**
	 * @return the serialversionuid
	 */
	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((buildDate == null) ? 0 : buildDate.hashCode());
		result = prime * result + ((buildNum == null) ? 0 : buildNum.hashCode());
		result = prime * result + ((buildServer == null) ? 0 : buildServer.hashCode());
		result = prime * result + ((moduleName == null) ? 0 : moduleName.hashCode());
		result = prime * result + ((moduleVersion == null) ? 0 : moduleVersion.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof AboutModel)) {
			return false;
		}
		final AboutModel other = (AboutModel) obj;
		if (buildDate == null) {
			if (other.buildDate != null) {
				return false;
			}
		} else if (!buildDate.equals(other.buildDate)) {
			return false;
		}
		if (buildNum == null) {
			if (other.buildNum != null) {
				return false;
			}
		} else if (!buildNum.equals(other.buildNum)) {
			return false;
		}
		if (buildServer == null) {
			if (other.buildServer != null) {
				return false;
			}
		} else if (!buildServer.equals(other.buildServer)) {
			return false;
		}
		if (moduleName == null) {
			if (other.moduleName != null) {
				return false;
			}
		} else if (!moduleName.equals(other.moduleName)) {
			return false;
		}
		if (moduleVersion == null) {
			if (other.moduleVersion != null) {
				return false;
			}
		} else if (!moduleVersion.equals(other.moduleVersion)) {
			return false;
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("AboutModel ["); //$NON-NLS-1$
		if (moduleName != null) {
			builder.append("moduleName=").append(moduleName).append(", "); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (moduleVersion != null) {
			builder.append("moduleVersion=").append(moduleVersion).append(", "); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (buildNum != null) {
			builder.append("buildNum=").append(buildNum).append(", "); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (buildDate != null) {
			builder.append("buildDate=").append(buildDate).append(", "); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (buildServer != null) {
			builder.append("buildServer=").append(buildServer); //$NON-NLS-1$
		}
		builder.append("]");
		return builder.toString();
	}

}
