package org.jresearch.commons.gwt.client.model.time;

import java.io.Serializable;
import java.util.Date;

import javax.annotation.Nonnull;

/**
 * Wrapper for {@link Date} to correct convert it to joda link LocalDateTime
 *
 * @author kot
 *
 */
public class DateModel implements Serializable {

	private static final long serialVersionUID = 8904147631015139786L;

	@Nonnull
	private Date date;

	public DateModel() {
		this(new Date());
	}

	public DateModel(@Nonnull final Date date) {
		this.date = date;
	}

	/**
	 * @return the date
	 */
	@Nonnull
	public Date getDate() {
		return date;
	}

	/**
	 * @param date
	 *            the date to set
	 */
	public void setDate(@Nonnull final Date date) {
		this.date = date;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + getDate().hashCode();
		return result;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final DateModel other = (DateModel) obj;
		return getDate().equals(other.getDate());
	}

	@Override
	public String toString() {
		return getDate().toString();
	}

}
