package org.jresearch.commons.gwt.client.model.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.tools.Dates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class GwtLocalTimeModel implements Serializable {

    private static final long serialVersionUID = -4731534946440240947L;

    /** from 00:00 */
    private long miliseconds;

    public GwtLocalTimeModel() {
        // GWT
    }

    public GwtLocalTimeModel(final long miliseconds) {
        setMiliseconds(miliseconds);
    }

    public GwtLocalTimeModel(final int hours, final int minutes) {
        this(hours, minutes, 0);
    }

    public GwtLocalTimeModel(final int hours, final int minutes, final int seconds) {
        this(hours, minutes, seconds, 0);
    }

    public GwtLocalTimeModel(final int hours, final int minutes, final int seconds, final int miliseconds) {
        this(((hours * 60 + minutes) * 60 + seconds) * 1000 + miliseconds);
    }

    public GwtLocalTimeModel(final Date date) {
        this(Dates.getDayTime(date));
    }

    public GwtLocalTimeModel(final Calendar date) {
        this(Dates.getDayTime(date));
    }

    /**
     * @return the miliseconds
     */
    public long getMiliseconds() {
        return miliseconds;
    }

    /**
     * @param miliseconds
     *            the miliseconds to set
     */
    public void setMiliseconds(final long miliseconds) {
        this.miliseconds = miliseconds % Dates.DAY_LENGTH;
    }

    @SuppressWarnings("null")
    @Nonnull
    public Date toDate() {
        return Dates.setDayTime(miliseconds);
    }

    @SuppressWarnings("nls")
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("miliseconds", miliseconds)
                .toString();
    }

    @SuppressWarnings("boxing")
    @Override
    public int hashCode() {
        return Objects.hashCode(getMiliseconds());
    }

    @SuppressWarnings("boxing")
    @Override
    public boolean equals(final Object object) {
        if (object instanceof GwtLocalTimeModel) {
            final GwtLocalTimeModel that = (GwtLocalTimeModel) object;
            return Objects.equal(this.getMiliseconds(), that.getMiliseconds());
        }
        return false;
    }

}
