package org.jresearch.commons.gwt.client.mvc.event;

import org.jresearch.commons.gwt.client.model.localization.LocaleModel;

import com.google.gwt.event.shared.GwtEvent;

public class SetLanguageEvent extends GwtEvent<SetLanguageHandler> {

	@SuppressWarnings("unused")
	public static Type<SetLanguageHandler> TYPE = new Type<SetLanguageHandler>();

	private final LocaleModel locale;

	public SetLanguageEvent(LocaleModel locale) {
		this.locale = locale;
	}

	@Override
	public Type<SetLanguageHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(SetLanguageHandler handler) {
		handler.onSetLanguage(this);
	}

	/**
	 * @return the locale
	 */
	public LocaleModel getLocale() {
		return locale;
	}

}
