package org.jresearch.commons.gwt.client.mvc.event.module;

import java.util.Map;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.event.IHistoryEvent;
import org.jresearch.commons.gwt.shared.tools.Strings;

import com.google.common.collect.Maps;
import com.google.web.bindery.event.shared.Event;

public class ModuleEvent extends Event<ModuleHandler> implements IHistoryEvent {

	public static final String ANY_ID = ""; //$NON-NLS-1$
	private static final String DATA = "org.jresearch.commons.gwt.app.client.mvc.event.module.ModuleEvent_data"; //$NON-NLS-1$

	@SuppressWarnings("unused")
	public static Type<ModuleHandler> TYPE = new Type<ModuleHandler>();

	@Nonnull
	private final String moduleId;
	@Nonnull
	private final Map<String, Object> parameters;

	public ModuleEvent(@Nonnull final String moduleId) {
		this.moduleId = moduleId;
		parameters = Maps.newHashMap();
	}

	@Override
	public Type<ModuleHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final ModuleHandler handler) {
		final String id = handler.getModuleId();
		if (id.isEmpty() || moduleId.equals(id)) {
			handler.onModule(this);
		}
	}

	/**
	 * @return the moduleId
	 */
	@Nonnull
	public String getModuleId() {
		return moduleId;
	}

	@Override
	@Nonnull
	public String getToken() {
		return moduleId;
	}

	@Override
	@Nonnull
	public String getPageName() {
		return Strings.format("/{0}", moduleId); //$NON-NLS-1$
	}

	public <V> void addParameter(final String name, final V value) {
		parameters.put(name, value);
	}

	@SuppressWarnings("unchecked")
	public <V> V getParameter(final String name) {
		return (V) parameters.get(name);
	}

	public <V> void setData(final V value) {
		parameters.put(DATA, value);
	}

	@SuppressWarnings("unchecked")
	public <V> V getData() {
		return (V) parameters.get(DATA);
	}

}
