package org.jresearch.commons.gwt.shared.loader;

/**
 * {@link LoadConfig} with optional item to select right page
 *
 * @author kot
 *
 */
public interface PageCrudLoadConfig<M> extends CrudLoadConfig<M> {

    /**
     * Sets the item amount.
     *
     * @param amount the number of item amount to return
     */
    void setAmount(int amount);

    /** The number of item to return. */
    public int getAmount();

    /**
     * Sets the offset.
     *
     * @param offset start item to return
     */
    public void setOffset(int offset);

    /** The start item to return. */
    public int getOffset();

}
