package org.jresearch.commons.gwt.shared.tools;

import java.io.Serializable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class Hsl implements Serializable {

    private static final long serialVersionUID = 2309774626873754106L;

    private int h;
    private int s;
    private int l;

    public Hsl() {
        // GWT
    }

    public Hsl(final int h, final int s, final int l) {
        this.h = h;
        this.s = s;
        this.l = l;
    }

    /**
     * @return the h
     */
    public int getH() {
        return h;
    }

    /**
     * @param h the h to set
     */
    public void setH(final int h) {
        this.h = h;
    }

    /**
     * @return the s
     */
    public int getS() {
        return s;
    }

    /**
     * @param s the s to set
     */
    public void setS(final int s) {
        this.s = s;
    }

    /**
     * @return the l
     */
    public int getL() {
        return l;
    }

    /**
     * @param l the l to set
     */
    public void setL(final int l) {
        this.l = l;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("h", h) //$NON-NLS-1$
                .add("s", s) //$NON-NLS-1$
                .add("l", l) //$NON-NLS-1$
                .toString();
    }

    @SuppressWarnings("boxing")
    @Override
    public int hashCode() {
        return Objects.hashCode(getH(), getS(), getL());
    }

    @SuppressWarnings("boxing")
    @Override
    public boolean equals(final Object object) {
        if (object instanceof Hsl) {
            final Hsl that = (Hsl) object;
            return Objects.equal(this.getH(), that.getH())
                    && Objects.equal(this.getS(), that.getS())
                    && Objects.equal(this.getL(), that.getL());
        }
        return false;
    }

}
