package org.jresearch.commons.gwt.shared.tools;

import java.io.Serializable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class Hsv implements Serializable {

    private static final long serialVersionUID = -2197427112136643403L;

    private int h;
    private int s;
    private int v;

    public Hsv() {
        // GWT
    }

    public Hsv(final int h, final int s, final int v) {
        this.h = h;
        this.s = s;
        this.v = v;
    }

    /**
     * @return the h
     */
    public int getH() {
        return h;
    }

    /**
     * @param h the h to set
     */
    public void setH(final int h) {
        this.h = h;
    }

    /**
     * @return the s
     */
    public int getS() {
        return s;
    }

    /**
     * @param s the s to set
     */
    public void setS(final int s) {
        this.s = s;
    }

    /**
     * @return the v
     */
    public int getV() {
        return v;
    }

    /**
     * @param v the v to set
     */
    public void setV(final int v) {
        this.v = v;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("h", h) //$NON-NLS-1$
                .add("s", s) //$NON-NLS-1$
                .add("v", v) //$NON-NLS-1$
                .toString();
    }

    @SuppressWarnings("boxing")
    @Override
    public int hashCode() {
        return Objects.hashCode(getH(), getS(), getV());
    }

    @SuppressWarnings("boxing")
    @Override
    public boolean equals(final Object object) {
        if (object instanceof Hsv) {
            final Hsv that = (Hsv) object;
            return Objects.equal(this.getH(), that.getH())
                    && Objects.equal(this.getS(), that.getS())
                    && Objects.equal(this.getV(), that.getV());
        }
        return false;
    }

}
