package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ErrorEvent;

import com.google.web.bindery.event.shared.Event;

public abstract class AbstractMethodCallback<T> implements MethodCallback<T> {

    private final Event<?> event;
    protected final Bus bus;

    public AbstractMethodCallback(final Event<?> event, @Nonnull final Bus bus) {
        this.event = event;
        this.bus = bus;
    }

    public AbstractMethodCallback(@Nonnull final Bus bus) {
        this(null, bus);
    }

    @Override
    public void onFailure(final Method method, final Throwable caught) {
        bus.fire(new ErrorEvent(caught, event != null ? new EventCommand(event, bus) : null));
    }

}
