package org.jresearch.commons.gwt.client.tool;

import java.util.Collection;

public abstract class CollectionListConverter<V, C extends Collection<V>> implements IListConverter<V, C> {

	@Override
	public C remove(final V value, final C modelValue) {
		if (modelValue.contains(value)) {
			final C copy = copy(modelValue);
			copy.remove(value);
			return copy;
		}
		return modelValue;
	}

	@Override
	public C add(final V value, final C modelValue) {
		if (modelValue == null || !modelValue.contains(value)) {
			final C copy = modelValue == null ? create() : copy(modelValue);
			copy.add(value);
			return copy;
		}
		return modelValue;
	}

	protected C copy(final C original) {
		final C copy = create();
		copy.addAll(original);
		return copy;
	}

	abstract protected C create();
}
