package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ErrorEvent;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.Event;

public abstract class AbstractCallback<T> implements AsyncCallback<T> {

	private final Event<?> event;
	protected final Bus bus;

	public AbstractCallback(final Event<?> event, @Nonnull final Bus bus) {
		this.event = event;
		this.bus = bus;
	}

	public AbstractCallback(@Nonnull final Bus bus) {
		this(null, bus);
	}

	@Override
	public void onFailure(final Throwable caught) {
		bus.fire(new ErrorEvent(caught, event != null ? new EventCommand(event, bus) : null));
	}

}
