package org.jresearch.commons.gwt.client.entry;

import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.inject.Inject;

public class DirectUrlHandler implements ValueChangeHandler<String> {

    private boolean firstEntry = true;
    private final List<IEntryHandler> handlers;

    @Inject
    private DirectUrlHandler(@Nonnull final Set<IEntryHandler> handlers) {
        final Ordering<IEntryHandler> byPriority = Ordering.natural()
                .reverse()
                .onResultOf(new Function<IEntryHandler, Integer>() {
                    @Override
                    public Integer apply(final IEntryHandler input) {
                        return Integer.valueOf(input == null ? 0 : input.getPriority());
                    }
                });
        this.handlers = byPriority.immutableSortedCopy(handlers);
    }

    @Override
    public void onValueChange(final ValueChangeEvent<String> event) {
        if (firstEntry) {
            firstEntry = false;
            final String value = event.getValue();
            for (final IEntryHandler hadler : handlers) {
                if (hadler.handle(value)) {
                    break;
                }
            }
        }
    }

}
