package org.jresearch.commons.gwt.shared.loader;

import java.io.Serializable;
import java.util.List;

import org.jresearch.commons.gwt.shared.model.IDomainNewModel;

import com.google.common.base.MoreObjects;

public class PageLoadResultBean<M extends IDomainNewModel<?>> implements PageLoadResult<M>, Serializable {

    private static final long serialVersionUID = 4045237057657884214L;

    private int offset;
    private int total;
    private List<M> items;

    public PageLoadResultBean() {
        // default
    }

    public PageLoadResultBean(final int offset, final int total, final List<M> items) {
        this.offset = offset;
        this.total = total;
        this.items = items;
    }

    @Override
    public void setOffset(final int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return offset;
    }

    /**
     * @return the total
     */
    @Override
    public int getTotal() {
        return total;
    }

    /**
     * @param total the total to set
     */
    @Override
    public void setTotal(final int total) {
        this.total = total;
    }

    /**
     * @return the items
     */
    @Override
    public List<M> getItems() {
        return items;
    }

    /**
     * @param items the items to set
     */
    @Override
    public void setItems(final List<M> items) {
        this.items = items;
    }

    @SuppressWarnings("nls")
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("offset", offset)
                .add("total", total)
                .add("items", items)
                .toString();
    }

}
