package org.jresearch.commons.gwt.client.gin;

import org.jresearch.commons.gwt.client.entry.IEntryHandler;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.gwt.inject.client.multibindings.GinMultibinder;
import com.google.inject.Singleton;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

public class UtilsGinModule extends InstallableGinModule {

    private static final String ID = "UtilsGinModule"; //$NON-NLS-1$

    @Override
    protected void configure() {
        // create a simple global event bus
        bind(EventBus.class).to(SimpleEventBus.class).in(Singleton.class);
        // create a asynk wrapper for the event bus
        bind(Bus.class).in(Singleton.class);
        // create empty set of IEntryHandler
        GinMultibinder.newSetBinder(binder(), IEntryHandler.class);
    }

    @Override
    protected String getId() {
        return ID;
    }

}
