package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ErrorEvent;

import com.google.web.bindery.event.shared.Event;

public class GwtMethodCallback<T> implements MethodCallback<T> {

    private final Event<?> event;
    protected final Bus bus;
    private SuccessCallback<T> successCallback;
    private FailureCallback failureCallback;

    public GwtMethodCallback(final Event<?> event, @Nonnull final Bus bus, final SuccessCallback<T> successCallback, final FailureCallback failureCallback) {
        this.event = event;
        this.bus = bus;
        this.successCallback = successCallback;
        this.failureCallback = failureCallback;
    }

    public GwtMethodCallback(@Nonnull final Bus bus, final SuccessCallback<T> successCallback) {
        this(null, bus, successCallback, null);
    }

    public GwtMethodCallback(@Nonnull final Bus bus, final SuccessCallback<T> successCallback, final FailureCallback failureCallback) {
        this(null, bus, successCallback, failureCallback);
    }

    @Override
    public void onFailure(final Method method, final Throwable caught) {
        if (failureCallback != null) {
            failureCallback.onFailure(caught);
        } else {
            bus.fire(new ErrorEvent(caught, event != null ? new EventCommand(event, bus) : null));
        }
    }

    @Override
    public void onSuccess(final Method method, final T response) {
        successCallback.onSuccess(response);
    }

}
