package org.jresearch.commons.gwt.client.widget;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.IsWidget;

public class FieldDescriptor<V, F extends IsWidget & HasValue<V>> {

	private String path;
	private SafeHtml label;
	private F field;

	public FieldDescriptor(final SafeHtml label, final F field) {
		this(label, field, Uis.NOTHING);
	}

	public FieldDescriptor(final SafeHtml label, final F field, final String path) {
		this.label = label;
		this.field = field;
		this.path = path;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * @param path
	 *            the path to set
	 */
	public void setPath(final String path) {
		this.path = path;
	}

	/**
	 * @return the label
	 */
	public SafeHtml getLabel() {
		return label;
	}

	/**
	 * @param label
	 *            the label to set
	 */
	public void setLabel(final SafeHtml label) {
		this.label = label;
	}

	/**
	 * @return the field
	 */
	public F getField() {
		return field;
	}

	/**
	 * @param field
	 *            the field to set
	 */
	public void setField(final F field) {
		this.field = field;
	}

}
