package org.jresearch.commons.gwt.shared.loader;

import org.jresearch.commons.gwt.shared.model.IDomainNewModel;

public class PageCrudLoadConfigBean<M extends IDomainNewModel<?>> extends CrudLoadConfigBean<M>implements PageCrudLoadConfig<M> {

    private static final long serialVersionUID = -8647396475310263560L;

    private int offset;
    private int amount;

    public PageCrudLoadConfigBean() {
        // default
    }

    public PageCrudLoadConfigBean(final int offset, final int amount) {
        this(offset, amount, null);
    }

    public PageCrudLoadConfigBean(final M item, final int amount) {
        this(0, amount, item);
    }

    public PageCrudLoadConfigBean(final int offset, final int amount, final M itemToReload) {
        super(itemToReload);
        this.offset = offset;
        this.amount = amount;
    }

    @Override
    public void setAmount(final int amount) {
        this.amount = amount;
    }

    @Override
    public int getAmount() {
        return amount;
    }

    @Override
    public void setOffset(final int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return offset;
    }

}
