package org.jresearch.commons.gwt.client.app;

import java.util.List;
import java.util.logging.Logger;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.base.resource.BaseRs;
import org.jresearch.commons.gwt.client.mvc.AbstractView;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ScrollEvent;
import org.jresearch.commons.gwt.shared.tools.Strings;

import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Window;

@SuppressWarnings("rawtypes")
public abstract class AbstractAppView<C extends AbstractAppController> extends AbstractView<C> {

    private static final Logger LOGGER = Logger.getLogger("org.jresearch.commons.gwt.app.client.mvc.AbstractAppView"); //$NON-NLS-1$

    @Nonnull
    protected final Bus bus;

    public AbstractAppView(@Nonnull final C controller, @Nonnull final Bus bus) {
        super(controller);
        this.bus = bus;
        Window.addWindowScrollHandler(new Window.ScrollHandler() {
            private int lastPosition;

            @SuppressWarnings({ "synthetic-access", "boxing" })
            @Override
            public void onWindowScroll(final com.google.gwt.user.client.Window.ScrollEvent event) {
                final int scrollTop = event.getScrollTop();
                if (lastPosition != scrollTop) {
                    lastPosition = scrollTop;
                    final int scrollH = Document.get()
                            .getScrollHeight();
                    final int screenH = Document.get()
                            .getClientHeight();
                    if (scrollH - scrollTop <= screenH) {
                        LOGGER.fine(Strings.format("Scroll possition is {0}", scrollTop)); //$NON-NLS-1$
                        bus.fire(new ScrollEvent(scrollTop));
                    }
                }
            }
        });
    }

    public void onChangeOfflineMode(final boolean isOffline) {
        showInfo(BaseRs.TXT.offlineMode(isOffline));
    }

    abstract public void showAbout();

    abstract public boolean switchToModule(@Nonnull final String moduleId);

    abstract public boolean showModule(@Nonnull final String moduleId);

    abstract public boolean hideModule(@Nonnull final String moduleId);

    abstract public void initModules(final List<IAppModule> modules);

}
