package org.jresearch.commons.gwt.shared.loader;

import java.util.List;

/**
 * Paged result
 *
 * @author kot
 *
 */
public interface PageLoadResult<M> {

    /** @return the total item amount on server */
    int getTotal();

    /** @param total - the total length of items on backend. */
    public void setTotal(int total);

    /**
     * Sets the offset.
     *
     * @param offset start item to return
     */
    void setOffset(int offset);

    /** The start item in the result. */
    int getOffset();

    /**
     * Sets the requested items.
     *
     * @param items to return in result
     */
    void setItems(List<M> items);

    /** @return the requested items */
    public List<M> getItems();

}
