package org.jresearch.commons.gwt.flexess.client.service;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.service.AccessDenidedException;
import org.jresearch.commons.gwt.client.service.NoUserException;
import org.jresearch.commons.gwt.flexess.client.service.flexess.IGwtAuthenticationData;
import org.jresearch.commons.gwt.flexess.shared.model.AuthData;
import org.jresearch.commons.gwt.shared.model.DomainNewModel;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("flexessService.gwt")
public interface FlexessService extends RemoteService {

	public enum AuthStatus {
		Authenticated,
		NotEnroled,
		BadCredentials,
		NotAuthorized,
		Reset
	}

	public enum ResetStatus {
		Done,
		Disable,
		NotFound
	}

	public enum SignUpStatus {
		Done,
		Disable,
		Exist
	}

	String ID = "FlexessService_SERVICE"; //$NON-NLS-1$

	/**
	 * @return <code>true</code> if user manager allows to reset authentication
	 */
	boolean isResetEnable();

	/**
	 * Reset by user email
	 *
	 * @param email
	 *            - email to reset
	 */
	@Nonnull
	ResetStatus reset(@Nonnull String email);

	/**
	 * @return <code>true</code> if user manager allows to public registration
	 */
	boolean isSignUpEnable();

	/**
	 * Register user with given email
	 *
	 * @param email
	 *            - email to reset
	 */
	@Nonnull
	SignUpStatus signUp(@Nonnull String email);

	/**
	 * logout current user
	 */
	void logOut();

	@SuppressWarnings("rawtypes")
	void check(@Nonnull DomainNewModel object, @Nonnull String operation) throws NoUserException, AccessDenidedException;

	void check(@Nonnull String object, @Nonnull String operation) throws NoUserException, AccessDenidedException;

	// void check(@Nonnull ClientObject object, @Nonnull String operation)
	// throws NoUserException, AccessDenidedException;

	@Nonnull
	AuthData authenticate(@Nonnull IGwtAuthenticationData<?> data);

}