package org.jresearch.commons.gwt.flexess.client.service.flexess;

import java.io.Serializable;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.oauth2.shared.model.SocialNetwork;

public class SocialAuthenticationObject implements Serializable {

	private static final long serialVersionUID = -6694224801933031333L;

	private String authenticationToken;
	private SocialNetwork network;

	public SocialAuthenticationObject(@Nonnull final SocialNetwork network, @Nonnull final String authenticationToken) {
		this.authenticationToken = authenticationToken;
		this.network = network;
	}

	public SocialAuthenticationObject() {
		// GWT
	}

	/**
	 * @return the authenticationToken
	 */
	public String getAuthenticationToken() {
		return authenticationToken;
	}

	/**
	 * @param authenticationToken
	 *            the authenticationToken to set
	 */
	public void setAuthenticationToken(@Nonnull final String authenticationToken) {
		this.authenticationToken = authenticationToken;
	}

	/**
	 * @return the network
	 */
	public SocialNetwork getNetwork() {
		return network;
	}

	/**
	 * @param network
	 *            the network to set
	 */
	public void setNetwork(@Nonnull final SocialNetwork network) {
		this.network = network;
	}

}
