package org.jresearch.commons.gwt.flexess.client.service;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.flexess.shared.model.AuthData;
import org.jresearch.commons.gwt.flexess.shared.service.FlexessService;
import org.jresearch.commons.gwt.flexess.shared.service.flexess.GwtAuthenticationData;

public interface FlexessRestService extends FlexessService, DirectRestService {

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_RESET)
	@Override
	Boolean isResetEnable();

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_U_RESET)
	@Override
	ResetStatus reset(String email);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_SIGNUP)
	@Override
	Boolean isSignUpEnable();

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_U_SIGNUP)
	@Override
	SignUpStatus signUp(String email);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_U_LOGOUT)
	@Override
	void logOut();

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_AUTH)
	@Override
	AuthData authenticate(GwtAuthenticationData data);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_REFRESH)
	@Override
	AuthData refreshAuthenticatedToken(String refreshToken);

}
