package org.jresearch.commons.gwt.flexess.client.service;

import java.util.List;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.flexess.shared.model.RoleModel;
import org.jresearch.commons.gwt.flexess.shared.service.AdminFlexessService;
import org.jresearch.commons.gwt.shared.loader.PageCrudRestLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.PageLoadResultBean;

public interface AdminFlexessRestService extends AdminFlexessService, DirectRestService {

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_D)
	@Override
	void remove(List<RoleModel> model);

	@PUT
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_C)
	@Override
	RoleModel create(RoleModel prototype);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_U)
	@Override
	void update(RoleModel model);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_R)
	@Override
	PageLoadResultBean<RoleModel> getAll(PageCrudRestLoadConfigBean<RoleModel> config);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_BY_USER)
	@Override
	List<RoleModel> getGwtUserRoles(String userName);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_U_BY_USER)
	@Override
	void updateRoles(@PathParam("userName") String userName, List<RoleModel> roles);

}
