package org.jresearch.commons.gwt.flexess.client.model;

import java.io.Serializable;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.flexess.client.service.FlexessService.AuthStatus;

/**
 * @author Kot
 * 
 */
public class AuthData implements Serializable {

	private static final long serialVersionUID = 7855710124783355473L;

	@Nonnull
	private AuthStatus authStatus = AuthStatus.NotAuthorized;
	private String userId;

	public AuthData() {
		// For GWT
	}

	public AuthData(@Nonnull AuthStatus authStatus) {
		this(authStatus, null);
	}

	public AuthData(@Nonnull AuthStatus authStatus, String userId) {
		this.authStatus = authStatus;
		this.userId = userId;
	}

	/**
	 * @return the authStatus
	 */
	@Nonnull
	public AuthStatus getAuthStatus() {
		return authStatus;
	}

	/**
	 * @return the userId
	 */
	public String getUserId() {
		return userId;
	}

}
