package org.jresearch.commons.gwt.oauth2.client.model;

import java.io.Serializable;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.oauth2.shared.model.SocialNetwork;

@SuppressWarnings("null")
public class OauthConfiguration implements Serializable {

	private static final long serialVersionUID = 6767892369538910108L;

	private SocialNetwork network;
	private String authUrl;
	private String clientId;
	private String[] scopes;

	/**
	 * @return the authUrl
	 */
	@Nonnull
	public String getAuthUrl() {
		return authUrl;
	}

	/**
	 * @param authUrl
	 *            the authUrl to set
	 */
	public void setAuthUrl(@Nonnull String authUrl) {
		this.authUrl = authUrl;
	}

	/**
	 * @return the clientId
	 */
	@Nonnull
	public String getClientId() {
		return clientId;
	}

	/**
	 * @param clientId
	 *            the clientId to set
	 */
	public void setClientId(@Nonnull String clientId) {
		this.clientId = clientId;
	}

	/**
	 * @return the scopes
	 */
	public String[] getScopes() {
		return scopes;
	}

	/**
	 * @param scopes
	 *            the scopes to set
	 */
	public void setScopes(String[] scopes) {
		this.scopes = scopes;
	}

	/**
	 * @return the network
	 */
	@Nonnull
	public SocialNetwork getNetwork() {
		return network;
	}

	/**
	 * @param network
	 *            the network to set
	 */
	public void setNetwork(@Nonnull SocialNetwork network) {
		this.network = network;
	}

}
