package org.jresearch.commons.gwt.oauth2.client.mvc.event;

import org.jresearch.commons.gwt.oauth2.shared.model.SocialNetwork;

import com.google.web.bindery.event.shared.Event;

public class SocialAuthenticationEvent extends Event<SocialAuthenticationHandler> {

	@SuppressWarnings("unused")
	public static Type<SocialAuthenticationHandler> TYPE = new Type<SocialAuthenticationHandler>();

	private final SocialNetwork network;
	private final String token;

	public SocialAuthenticationEvent(SocialNetwork network, String token) {
		this.network = network;
		this.token = token;
	}

	@Override
	public Type<SocialAuthenticationHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(SocialAuthenticationHandler handler) {
		handler.onAuthentication(this);
	}

	/**
	 * @return the network
	 */
	public SocialNetwork getNetwork() {
		return network;
	}

	/**
	 * @return the token
	 */
	public String getToken() {
		return token;
	}

}
