package org.jresearch.commons.gwt.oauth2.client.mvc.event;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.oauth2.shared.model.SocialNetwork;

import com.google.web.bindery.event.shared.Event;

public class SocialAuthenticationEvent extends Event<SocialAuthenticationHandler> {

    public static final Type<SocialAuthenticationHandler> TYPE = new Type<>();

    @Nonnull
    private final SocialNetwork network;
    @Nonnull
    private final String token;

    public SocialAuthenticationEvent(@Nonnull final SocialNetwork network, @Nonnull final String token) {
        this.network = network;
        this.token = token;
    }

    @Override
    public Type<SocialAuthenticationHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(final SocialAuthenticationHandler handler) {
        handler.onAuthentication(this);
    }

    /**
     * @return the network
     */
    @Nonnull
    public SocialNetwork getNetwork() {
        return network;
    }

    /**
     * @return the token
     */
    @Nonnull
    public String getToken() {
        return token;
    }

}
